@echo off

REM
REM Need to be administrator to run this file
REM
for /f "tokens=*" %%a in ('AT') do (
	set permission=%%a
) 

if "%permission%" == "Access is denied." (
	echo "Administrator privileges required to run this file"
	exit /b -1
)

REM
REM 32-bit path
REM
set intuitDir="%commonprogramfiles%\Intuit"
set dbProviders="%commonprogramfiles%\Intuit\Database Providers"
set updateService="%commonprogramfiles%\Intuit\Update Service v4"

REM
REM 64-bit path
REM
set intuitDirx86="%commonprogramfiles(x86)%\Intuit"
set dbProvidersx86="%commonprogramfiles(x86)%\Intuit\Database Providers"
set updateServicex86="%commonprogramfiles(x86)%\Intuit\Update Service v4"

REM
REM log file path
REM
set logFile=dmesd.log
set xpLogPath="%allusersprofile%\Application Data\Intuit\TurboTax\MSI\TY18\Logs"
set vistaWinxLogPath="%allusersprofile%\Intuit\TurboTax\MSI\TY18\Logs"

set ERRORLEVEL=0

REM
REM Check if 64-bit OS.  If so, then use icacls on 64-bit path
REM
if defined ProgramFiles(x86) (
	REM
	REM Check if log directory exists
	REM

	if not exist %vistaWinxLogPath% (
		mkdir %vistaWInxLogPath%
		echo mkdir %vistaWInxLogPath% >> %vistaWinxLogPath%\%logFile%
	)		

	REM
	REM Set permissions for parent Intuit directory
	REM
 	if exist %intuitDirx86% (
 		@echo Resetting 64-bit OS permissions for %intuitDirx86% >> %vistaWinxLogPath%\%logFile%
 		@echo icacls %intuitDirx86% /reset >> %vistaWinxLogPath%\%logFIle% >> %vistaWinxLogPath%\%logFile%
 		icacls %intuitDirx86% /reset >> %vistaWinxLogPath%\%logFile% 2>&1
 	)

	REM
	REM Set permissions for Intuit sub-directory
	REM
 	if exist %dbProvidersx86% (
 		@echo Resetting 64-bit OS permissions for %dbProvidersx86% >> %vistaWinxLogPath%\%logFile%
 		@echo icacls %dbProvidersx86% /reset /T >> %vistaWinxLogPath%\%logFIle% >> %vistaWinxLogPath%\%logFile%
 		icacls %dbProvidersx86% /reset /T >> %vistaWinxLogPath%\%logFile% 2>&1
 	)

	REM
	REM Set permissions for Intuit sub-directory
	REM
 	if exist %updateServicex86% (
 		@echo Resetting 64-bit OS permissions for %updateServicex86% >> %vistaWinxLogPath%\%logFile%
 		@echo icacls %updateServicex86% /reset /T >> %vistaWinxLogPath%\%logFile% >> %vistaWinxLogPath%\%logFile%
 		icacls %updateServicex86% /reset /T >> %vistaWinxLogPath%\%logFile% 2>&1
 	)
 ) else (
	REM
	REM Use cacls if XP. Otherwise, use icacls.
	REM

	REM Because XP is NT 5.1
	ver | findstr /i "5\.1\." > nul
	IF %ERRORLEVEL% EQU 0 (
		REM
		REM Check if log directory exists
		REM
		if not exist %xpLogPath% (
			mkdir %xpLogPath%
			echo mkdir %xpLogPath% >> %xpLogPath%\%logFile%
		)		

		if exist %intuitDir% (
			@echo Resetting 32-bit XP OS permissions for %intuitDir% >> %xpLogPath%\%logFile%

			@echo cacls %intuitDir% /C /E /G Administrators:F SYSTEM:F >> %xpLogPath%\%logFile%
			cacls %intuitDir% /C /E /G Administrators:F SYSTEM:F >> %xpLogPath%\%logFile% 2>&1
		)

		REM
		REM Need to run cacls twice to get all subdirs/files even though /T flag should do it.
		REM
		if exist %dbProviders% (
			@echo Resetting 32-bit XP OS permissions for %dbProviders% >> %xpLogPath%\%logFile%

			@echo cacls %dbProviders% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile%
			cacls %dbProviders% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile% 2>&1

			@echo cacls %dbProviders% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F "CREATOR OWNER":F >> %xpLogPath%\%logFile%
			cacls %dbProviders% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile% 2>&1
		)
		if exist %updateService% (
			@echo Resetting 32-bit XP OS permissions for %updateService% >> %xpLogPath%\%logFile%

			@echo cacls %updateService% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile%
			cacls %updateService% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile% 2>&1

			@echo cacls %updateService% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile%
			cacls %updateService% /T /C /E /G Administrators:F SYSTEM:F %USERNAME%:F >> %xpLogPath%\%logFile% 2>&1
		)
	) else (
		REM
		REM Check if log directory exists
		REM
		if not exist %vistaWinxLogPath% (
			mkdir %vistaWInxLogPath%
			echo mkdir %vistaWInxLogPath% >> %vistaWinxLogPath%\%logFile%
		)		

		if exist %intuitDir% (
			@echo Resetting 32-bit non-XP OS permissions for %intuitDir% >> %vistaWinxLogPath%\%logFile%
			@echo icacls %intuitDir% /reset >> %vistaWinxLogPath% >> %vistaWinxLogPath%\%logFile%
			icacls %intuitDir% /reset >> %vistaWinxLogPath%\%logFile% 2>&1
		)

		if exist %dbProviders% (
			@echo Resetting 32-bit non-XP OS permissions for %dbProviders% >> %vistaWinxLogPath%\%logFile%
			@echo icacls %dbProviders% /reset /T >> %vistaWinxLogPath% >> %vistaWinxLogPath%\%logFile%
			icacls %dbProviders% /reset /T >> %vistaWinxLogPath%\%logFile% 2>&1
		)
		if exist %updateService% (
			@echo Resetting 32-bit non-XP OS permissions for %updateService% >> %vistaWinxLogPath%\%logFile%
			@echo icacls %updateService% /reset /T >> %vistaWinxLogPath%\%logFile% >> %vistaWinxLogPath%\%logFile%
			icacls %updateService% /reset /T >> %vistaWinxLogPath%\%logFile% 2>&1
		)
	)
)
